if(tutorial_settings == nil) then
  tutorial_settings = {played = false}
end
local played_in_past = tutorial_settings.played
state:on_save(function(save)
  tutorial_settings.played = true
  save:set("tutorial_settings", tutorial_settings)
end)

state:suppress_toolbar_menu();
state:suppress_transport_menu();
state:suppress_interface_hints();

local portal_in = resize.location.portal_in
local portal_out = resize.location.portal_out

function tutorial_routine_first()
  return coroutine.wrap(function()
    state:suppress_transport_menu(false)
    set_user_input_filter(only_play_filter)
    embed(ramp_until(
      function() return not state:is_at_start() end,
      do_all(highlight_menu_item_lambda("play_pause_button"), announce_lambda("Try this factory", 0.15))
    ))
    embed(pause_until(function() return state.grid:ticks() >= 5 end))
    embed(ramp_until(
      function() return state.grid:ticks() >= 27 end,
      announce_lambda("Portals can rotate objects.", 0.1)
    ))
    embed(announce("But our output isn't quite right.", 3, 0.1))
    embed(ramp_until(function() return false end, do_all(
      announce_lambda("Try again.", 0.2),
      highlight_menu_item_lambda("stop_button")
    )))
  end)
end
function is_done()
  for v in each_vector(portal_in) do
    if state.grid:at(v) == nil then
      return false
    end
  end
  for v in each_vector(portal_out) do
    if state.grid:at(v) == nil then
      return false
    end
  end
  return true
end
function is_portal_selected()
  local partial = state:get_partial_interaction()
  if partial.type == "PartialCreatePortal" then
    return true
  end
end
local function only_open_portal(i)
  return i == PlayerInteraction.place_portal;
end
local allow_click = function()
  return true
end
local function is_mouse_interaction(i)
  if i.type == "MouseEventAction" then
    if i.event == MouseEventAction.rmb_click then
      return true
    elseif i.event == MouseEventAction.lmb_click then
      return allow_click()
    end
  elseif i.type == "MouseUpdateAction" then
    return i.lmb == MOUSE_NONE
  end
  return false
end
local function is_portal_widener(i)
  if i == PlayerInteraction.widen_portal then
    local partial = state:get_partial_interaction()
    if partial.type == "PartialCreatePortal" then
      return partial.width < 2
    end
  elseif i == PlayerInteraction.narrow_portal then
    local partial = state:get_partial_interaction()
    if partial.type == "PartialCreatePortal" then
      return partial.width > 2
    end
  end
  return false
end
local function is_rotation_interaction(i)
  if i.type == "MouseEventAction" then
    if i.event == MouseEventAction.scroll_up or i.event == MouseEventAction.scroll_down then
      return true
    end
  else
    return i == PlayerInteraction.rotate_right or i == PlayerInteraction.rotate_left
  end
  return false
end
local function is_flip_interaction(i)
  if i.type == "MouseEventAction" then
    if i.event == MouseEventAction.mmb_click then
      return true
    end
  else
    return i == PlayerInteraction.flip
  end
  return false
end
local function allow_portal_click()
  local partial = state:get_partial_interaction()
  if partial.type == "PartialCreatePortal" then
    if partial.width ~= 2 then
      return false
    end
    if partial.output == nil then
      if partial.input_orientation == ID then
        return partial.input == portal_in.lesser
      end
    else
      if partial.output_orientation == F0 then
        return partial.output == portal_out.greater
      end
    end
  end
  return false
end
local function is_portal_narrow()
  local partial = state:get_partial_interaction()
  if partial.type == "PartialCreatePortal" then
    return partial.width ~= 2
  end
  return false
end
local function is_setting_portal_input()
  local partial = state:get_partial_interaction()
  if partial.type == "PartialCreatePortal" then
    return partial.output == nil and partial.width == 2
  end
  return false
end
local function is_setting_portal_output()
  local partial = state:get_partial_interaction()
  if partial.type == "PartialCreatePortal" then
    return partial.output ~= nil and partial.width == 2
  end
  return false
end
local function is_portal_output_flipped()
  local partial = state:get_partial_interaction()
  if partial.type == "PartialCreatePortal" then
    return partial.output_orientation == F0
  end
end

function tutorial_routine_second()
  return coroutine.wrap(function()
    set_user_input_filter(restrictive_filter)
    embed(announce("Let's fix this factory.", 3, 0.1, captured_cancel()))
    state:suppress_toolbar_menu(false)
    embed(pause(0.25))
    while not is_done() do
      set_user_input_filter(only_open_portal)
      embed(ramp_until(is_portal_selected, do_all(
        announce_lambda("Tool: Portal", 0.2),
        highlight_menu_item_lambda("toolbar_3")
      )))
      allow_click = allow_portal_click
      set_user_input_filter(lifted_or(is_portal_widener, is_mouse_interaction))
      embed(ramp_while(is_portal_narrow, do_all(
        announce_lambda("Press 'a' to widen portal.", 0.1),
        announce_lambda("('s' to narrow).", 0.06, -0.09)
      )))
      set_user_input_filter(is_mouse_interaction)
      embed(ramp_while(is_setting_portal_input, do_all(
        announce_lambda("Place input portal here.", 0.1),
        bouncing_arrow_at_game_lambda(portal_in, 0.06, DOWN),
        glowing_box_at_game_lambda(portal_in)
      )))
      set_user_input_filter(lifted_or(is_mouse_interaction, is_flip_interaction))
      embed(ramp_while(
        lifted_and(
          is_setting_portal_output,
          lifted_not(is_portal_output_flipped)
        ),
        do_all(
          announce_lambda("Press F to flip", 0.15, -0.08),
          announce_lambda("(Or middle mouse click)", 0.08, -0.2)
        )
      ))
      set_user_input_filter(lifted_or(is_mouse_interaction, is_flip_interaction))
      embed(ramp_while(
        lifted_and(
          is_setting_portal_output,
          is_portal_output_flipped
        ),
        do_all(
          announce_lambda("Place output portal here.", 0.1, -0.08),
          bouncing_arrow_at_game_lambda(portal_out, 0.06, DOWN),
          glowing_box_at_game_lambda(portal_out)
        )
      ))
      embed(pause(0.01))
    end
    embed(tutorial_routine_finished())
  end)
end
function tutorial_routine_finished()
  return coroutine.wrap(function()
    state:suppress_toolbar_menu()
    state:suppress_transport_menu(false)
    set_user_input_filter(only_play_or_speed_or_cancel_filter)
    embed(ramp_while(is_portal_selected, announce_lambda("Right click to exit portal tool", 0.08, -0.08)))
    set_user_input_filter(only_play_or_stop_or_speed_filter)
    embed(ramp_until(
      function() return not state:is_at_start() end,
      do_all(highlight_menu_item_lambda("play_pause_button"), announce_lambda("Turn on factory", 0.15, -0.1))
    ))
  end)
end

function tutorial_routine()
  if not played_in_past then
    return tutorial_routine_first()
  elseif not is_done() then
    return tutorial_routine_second()
  else
    return tutorial_routine_finished()
  end
end


draw_interpreted_routine(tutorial_routine())
